function toggle(id) {
	var e=$(id);	if (e) { e.style.display=='none'?show(e):hide(e);}
	return false;
}

function show(id) {
  var e=$(id);	if (e) { e.style.display = ''; }
	return false;
}

function hide(id)
{
	var e=$(id);if (e) { e.style.display = 'none';}
	return false;
}

function cleanHTML(str) {
	var div = new Element('DIV');
	div.innerHTML = str.replace(/<\/?[^>]+>/gi, '');
	return div.childNodes[0] ? div.childNodes[0].nodeValue : '';
}

function showtip(e) {
	var tip=$('tooltip4'+e.id);
	if (tip) {
		if (tip.style.visibility!='hidden') return;
		tip.fade = tip.effect('opacity', {duration:500});
		tip.fade.start(0,1);
	}
}

function hidetip(e) {
	var tip = $(e).getParent();
	if (tip) tip.fade.start(1,0);
}

//AJAX CALLS
function check_username_available()
{
	var username = $('username');
	if (username) {
		var url = '/dashboard/ajax-handlers.php';
		var params = {'handler': 'check_username_available','arg0': username.value}
		params = Object.toQueryString(params);
		new Ajax(url, {
			method: 'post',
			onFailure: check_username_available,
			onSuccess: check_username_available_result,
			data: params
		}).request();
		ajaxmsgclr();
	}
}

function check_username_available_result(txtDoc)
{
	ajaxmsgclr();
	var target = $('check-username');
		if (txtDoc == 'SUCCESS') {
			var msg = "<p><b>Yes!</b> That username is available.</p></div>";
			ajaxmsg('success', msg, target);
		} else {
			var msg = "<p>"+txtDoc+"</p>";
			ajaxmsg('error', msg, target);
		}
}

function forgot_pass()
{
  var email = document.getElementById('email');
  if (email) {
		var url = '/dashboard/ajax-handlers.php';
		var params = {'handler': 'forgot_pass','arg0': email.value}
		params = Object.toQueryString(params);
		new Ajax(url, {
			method: 'post',
			onFailure: forgot_pass,
			onSuccess: forgot_pass_result,
			data:params
		}).request();
		ajaxmsgclr();
	}
}

function forgot_pass_result(txtDoc)
{
	ajaxmsgclr();
	var target = $('lp-msg');
	var email = document.getElementById('email');
	if (txtDoc== 'SUCCESS') {
		var msg = "<p>An email with instructions to reset your password has been sent to "+ email.value + ".</p>";
		ajaxmsg('success', msg, target);
		toggle('resetpwd');
	} else {
		var msg = "<p>"+txtDoc+"</p>";
		ajaxmsg('error', msg, target);
	}
}

function save_label(network_id, label)
{
	var url = '/dashboard/ajax-handlers.php';
	var params = {'handler': 'save_label','arg0': network_id, 'arg1': label};
	params = Object.toQueryString(params);
	new Ajax(url, {method: 'post',data: params, evalResponse: true}).request();
}

function save_shortcut(shortcut_id, label, surl)
{
	var url = '/dashboard/ajax-handlers.php';
	var params = {'handler': 'save_shortcut',
		'arg0': shortcut_id, 
		'arg1': label,
		'arg2': surl
	};
	params = Object.toQueryString(params);
	new Ajax(url, {method: 'post',data: params, evalResponse: true}).request();
}

function save_domain(domain_id, network_id, domain, handler)
{
	var url = '/dashboard/ajax-handlers.php';
	var params = {'handler': handler,'arg0': domain_id, 'arg1': network_id,'arg2': domain};
	params = Object.toQueryString(params);
	new Ajax(url, {method: 'post',data: params, evalResponse: true}).request();
}

function confirm_delete_logo(e)
{
  var agree = confirm("Are you sure you want to delete this logo? Any networks using it will be set to the default.");
  if (agree) { 
		var logo_id = e.id;
		var url = '/dashboard/ajax-handlers.php';
		var params = {'handler': 'delete_logo','arg0': logo_id}
		params = Object.toQueryString(params);
		new Ajax(url, {
			method: 'post',
			onSuccess: function(resp) {
				if(resp!='FAIL') {
					var old_logo = $('logobox'+resp);
					if (old_logo.getFirst().getFirst().checked) {
						var defid=$('defaultlogo').value;
						var target = $('logobox'+defid);
						if(target) {
						 target.getFirst().getFirst().checked=true;
						} else {
							$('deflogobox').getFirst().getFirst().checked=true;
						}
					}
					old_logo.remove();
				}
			},
			data:params
		}).request();
	}
	return false;
}

function resend_new_email(e, newemail)
{
	var url = '/dashboard/ajax-handlers.php';
	var params = {'handler': 'resend_new_email','arg0': newemail}
	params = Object.toQueryString(params);
	new Ajax(url, {
		method: 'post',
		onSuccess: function(resp) {
			if (resp=='SUCCESS') {
				ajaxmsg('success', 'Confirmation email resent to ' + newemail, $('sub-canvas'));
			} else {
				ajaxmsg('error', 'We\'ve recently emailed you at ' + newemail + ', try again in a few minutes.', $('sub-canvas'));
			}
		},
		data:params
	}).request();
	return false;
}

function resend_account_confirmation(username)
{
	var url = '/dashboard/ajax-handlers.php';
	var params = {'handler': 'resend_account_confirmation','arg0': username}
	params = Object.toQueryString(params);
	new Ajax(url, {method: 'post',data: params, evalResponse: true}).request();
	return false;
}

function update_ip(network_id)
{
	var url = '/dashboard/ajax-handlers.php';
	var params = {'handler': 'update_ip',	'arg0': network_id };
	params = Object.toQueryString(params);
	new Ajax(url, {method: 'post',data: params, evalResponse: true}).request();
	return false;
}

function delete_pending_network(network_id)
{
	var url = '/dashboard/ajax-handlers.php';
	var params = {'handler': 'delete_pending_network', 'arg0': network_id };
	params = Object.toQueryString(params);
	new Ajax(url, {method: 'post',data: params, evalResponse: true}).request();
	return false;
}

function resend_verify_network(network_id)
{
	var url = '/dashboard/ajax-handlers.php';
	var params = {'handler': 'resend_verify_network', 'arg0': network_id };
	params = Object.toQueryString(params);
	new Ajax(url, {method: 'post',data: params, evalResponse: true}).request();
	return false;
}

function block_domain(network_id, domain)
{
	var url = '/dashboard/ajax-handlers.php';
	var params = {'handler': 'block_domain', 'arg0': network_id, 'arg1': domain};
	params = Object.toQueryString(params);
	new Ajax(url, {method: 'post',data: params, evalResponse: true}).request();
	return false;
}

function ajaxmsgclr()
{
	$ES('.success, .error').each(function(e){e.remove()});
}

function ajaxmsg(type, msg, e) {
	ajaxmsgclr();
	var box = new Element('DIV');
	box.id = 'ajaxmsg';
	if (type=='success') {
		box.removeClass('error');
		box.addClass('success');
		box.setHTML('<p>' + msg + '</p>');
	} else {
		box.removeClass('success');
		box.addClass('error');
		box.setHTML('<p>' + msg + '</p>');
	}
	box.injectBefore($(e).getFirst());
	yft(box);
}
	
function use_this_ip()
{
	var ip = document.getElementById('current-ip');
	if (ip) {
		ip=ip.innerHTML;
		var octets = ip.split('.');
		for (i=0 ; i<4 ; i++) {
			document.addnetwork['cidr_base_octet'+(i+1)].value=octets[i];
		}
		document.addnetwork.cidr_prefix.value = 32;
	}
	document.addnetwork.submit();
}

function select_all_boxes(e, name)
{
	var boxes = document.getElementsByName(name);
	var num_checked=0;
	var all_checked = true;
	for (var i = 0; i < boxes.length ; i++) {
		if (boxes[i].checked) num_checked++;
	}
	if (num_checked==boxes.length) all_checked = false;
	for (var i = 0; i < boxes.length ; i++) {
		if (!boxes[i].disabled) {
			boxes[i].checked = all_checked;
		}
	}
	e.checked=all_checked;
	return false;
}

function set_disabled(name, flag)
{
	var targets = document.getElementsByName(name);
	for (var i = 0; i < targets.length ; i++) {
		targets[i].disabled = flag;
	}
}

function make_netlabel_editable(e) {
	e.et = e.getFirst();
	e.el = e.et.getNext();
	
	var click_func = function() {
		hide(e.el);hide(e.et);
		e.edit_field = new Element('INPUT');
		e.save       = new Element('INPUT');
		e.cancel     = new Element('INPUT');
		e.edit_field.setProperties({type: 'text', value: $(e).et.innerHTML});
		e.save.setProperties({type: 'button', value: 'Save'});
		e.cancel.setProperties({type:  'button', value: 'Cancel'});
		e.save.addClass('ajaxbutton');
		e.cancel.addClass('ajaxbutton');

		var save_func  = function() {
			$(e).et.innerHTML = 'Saving...';
			save_label($(e).id, $(e).edit_field.value);
		}
		e.edit_field.save = save_func;
		e.edit_field.addEvent('keydown', save_on_enter); 
		e.save.addEvent('click', save_func);
		e.cancel.addEvent('click', function() {
			e.cancel.remove();
			e.save.remove();
			e.edit_field.remove();
			show(e.el);show(e.et);
		});
		e.cancel.injectAfter($(e).el);
		e.save.injectAfter($(e).el);
		e.edit_field.injectAfter($(e).el);
		e.edit_field.focus();
	};
	e.et.addEvent('click', click_func);
	e.el.addEvent('click', click_func);
}

function make_shortcut_editable(e) {
	var cells = e.getChildren();
	e.s_label = cells[0].getFirst();
	e.s_url   = cells[1].getFirst();
	var enable_eip = function() {
		hide(e.s_label); hide(e.s_url);
		e.label_field = new Element('INPUT');
		e.url_field   = new Element('INPUT');
		e.save        = new Element('INPUT');
		e.cancel      = new Element('INPUT');
		e.lbreak      = new Element('BR');
		var clean_url   = cleanHTML($(e).s_url.innerHTML);
		e.label_field.setProperties({size: '10', type: 'text', value: $(e).s_label.innerHTML});
		e.url_field.setProperties({size: '40', type: 'text', value: clean_url});
		e.save.setProperties({type: 'button', value: 'Save'});
		e.cancel.setProperties({type:  'button', value: 'Cancel'});
		e.save.addClass('ajaxbutton');
		e.cancel.addClass('ajaxbutton');
	
		var save_func = function() {
			$(e).s_label.pval = $(e).s_label.innerHTML;
			$(e).s_label.innerHTML = 'Saving...';
			save_shortcut($(e).id, $(e).label_field.value, $(e).url_field.value);
		}

		e.label_field.save = save_func;
		e.url_field.save = save_func;

		e.label_field.addEvent('keydown', save_on_enter);		
		e.url_field.addEvent('keydown', save_on_enter);

		e.save.addEvent('click', save_func);
		e.cancel.addEvent('click', function() {
			show(e.s_label); show(e.s_url);
			e.cancel.remove();
			e.save.remove();
			e.label_field.remove();
			e.url_field.remove();
			e.lbreak.remove();
		});
		e.label_field.injectAfter(e.s_label);
		e.label_field.focus();
		e.url_field.injectAfter(e.s_url);
		e.lbreak.injectInside(cells[1]);
		e.save.injectInside(cells[1]);
		e.cancel.injectInside(cells[1]);
	};
	e.s_label.addEvent('click', enable_eip);
	e.s_url.addEvent('click', enable_eip);
}

function make_domain_editable(e, save_handler) {
	var click_func = function() {
		hide(e);
		e.edit_field = new Element('INPUT');
		e.save       = new Element('INPUT');
		e.cancel     = new Element('INPUT');
		e.edit_field.setProperties({type: 'text', value: $(e).innerHTML});
		e.save.setProperties({type: 'button', value: 'Save'});
		e.cancel.setProperties({type:  'button', value: 'Cancel'});
		e.save.addClass('ajaxbutton');
		e.cancel.addClass('ajaxbutton');

		var save_func  = function() {
			save_domain($(e).id, $(e).network_id ,$(e).edit_field.value, save_handler);
		}
		e.edit_field.save = save_func;
		e.edit_field.addEvent('keydown', save_on_enter); 
		e.save.addEvent('click', save_func);
		e.cancel.addEvent('click', function() {
			e.cancel.remove();
			e.save.remove();
			e.edit_field.remove();
			show(e);
		});
		e.cancel.injectAfter(e);
		e.save.injectAfter(e);
		e.edit_field.injectAfter(e);
		e.edit_field.focus();
	};
	e.addEvent('click', click_func);
}

function make_bdomain_editable(e) {
	return make_domain_editable(e, 'save_bdomain');
}

function make_wldomain_editable(e) {
	return make_domain_editable(e, 'save_wldomain');
}

function make_nordrdomain_editable(e) {
	return make_domain_editable(e, 'save_nordrdomain');
}

function save_on_enter(ev) {
	ev = new Event(ev);
	if (ev.code==13) {
		ev.target.save();
		ev.stop();
	}
}

function updatetestimonial(current, interval) {
	var url = document.location.protocol + '//' + document.location.host + '/testimonial_ajax.php?current=' + current + '&interval=' + interval;
	var tajax = new Ajax(url, {
		method: 'get',
		evalResponse: true
	}).request();
};

function clear_field(field){
	if (field.defaultValue==field.value)
	field.value = ""
}

function yft(e)
{
	e.effect('background-color', {duration: 3000}).start('#ffffaa','#ffffff');
}

function count_text(field, field_count, field_max) {
	if (field.value.length > field_max) {
		field.value = field.value.substring(0, field_max);
	} else {
		field_count.value = field_max - field.value.length;
	}
}

function do_button_form_submit(button, name) {
	// stock DOM functions are used here becasue this 
	// function may be called where mootools is not available
	// like the logo edit form.
	if (!button.disabled) {
		var button_field = document.createElement('INPUT');
		button_field.type = 'hidden';
		button_field.name = 'action';
		button_field.value = name;
		button.form.appendChild(button_field);
		button.form.submit();
		button.disabled = true;
	}
	return false;
}

function redirect_settings_page(e, view)
{
	var index=e.selectedIndex;
	if (e.options[index].value) {
		window.location.href = '/dashboard/settings/'+e.options[index].value+'/'+view;
	}
	return false;
}

function redirect_stats_page(e)
{
	var index=e.selectedIndex;
	if (e.options[index].value) {
		(function () {
			window.location.href = '/dashboard/stats/'+e.options[index].value+'/overview';
		}).delay(500);
	}
	return false;
}

function stats_selector(form)
{
	var view = form.view.value;
	var net_id_str = (form.network_id.value==0)?'all_nets':form.network_id.value;
	var format     = form.format.value;
	var url        = '/dashboard/stats/'+net_id_str+'/'+view+'/'+format+'?';
	form.format.name=form.view.name=form.network_id.name='';
	window.location.href = url+$(form).toQueryString();
	return false;
}

function sign_up_page_toggle_hear_about_opendns(theselectbox) {
	if(theselectbox.value == 'other') {
		$('hearaboutwrapper').innerHTML = '<input name="hear_about_opendns" id="newhearabout" type="text" size="20" /><input type="hidden" name="use_ha_other" value="true" />';
		$('newhearabout').focus();
	};
}

function load_stats_charts() {
	var flashcharts = $ES(".statsdetailchart");
	flashcharts.each(function(e) {
		var fobj = new Object();
		fobj.src = e.getProperty('rel');
		fobj.type = "application/x-shockwave-flash";
		fobj.wmode = "transparent";
		fobj.width = parseInt(e.style.width);
		fobj.height = parseInt(e.style.height);
		// check for Flash
		if (typeof FlashDetect == 'object' && !FlashDetect.installed) {
			e.innerHTML = '<b style="font-size:10px;"><a target="_blank" style="color:#cc0000;" href="http://www.adobe.com/go/getflashplayer">Install the Flash player</a> to view this chart.</b>';
		} else {
			e.innerHTML = '<embed type="application/x-shockwave-flash" wmode="transparent" src="'+fobj.src+'" width="'+fobj.width+'" height="'+fobj.height+'"></embed>';
		}
	});
}

function dt_uncat(baseurl, domain_id, uncat_id, ajax_path) {
	var category_id = $('dtuncat' + domain_id).value;
	$('vb-' + domain_id + '-' + uncat_id).innerHTML = '<center><img src="http://www.opendns.com/img/spinner_small.gif"></center>';
	var params = {'domain_id': domain_id, 'category_id': category_id, 'uncat_id': uncat_id};
	params = Object.toQueryString(params);
	new Ajax(ajax_path + 'uncat_ajax.php', {method: 'post', postBody: params, evalResponse: true}).request();
};

function dtframepostback(domain_id, category_id, vote, key) {
	var params = {'domain_id': domain_id, 'category_id': category_id, 'vote': vote, 'key': key, 'ajax': 'true'};
	params = Object.toQueryString(params);
	new Ajax('/community/domaintagging/domain/vote.php', {method: 'post', postBody: params}).request();
	setTimeout('top.location.reload();', 100);
};

function dt_post_vote(baseurl, domain_id, category_id, vote, key) {
	$('vb-' + domain_id + '-' + category_id).innerHTML = '<center><img src="http://www.opendns.com/img/spinner_small.gif"></center>';
	var params = {'domain_id': domain_id, 'category_id': category_id, 'vote': vote, 'key': key, 'ajax': 'true'};
	params = Object.toQueryString(params);
	new Ajax(baseurl, {method: 'post', postBody: params, evalResponse: true}).request();
}

function dtwordfilter_init() {
	if(!$('wfcheckbox')) {
		return;
	};
	var wfcookie = commonGetCookie('wfenabled');
	if(wfcookie == '0') {
		$('wfcheckbox').checked = false;
	} else {
		$('wfcheckbox').checked = true;
	};
	dtwordfilter_scan();
};

function dtwordfilter_check() {
	if(!$('wfcheckbox')) {
		return;
	};
	if($('wfcheckbox').checked) {
		commonSetCookie('wfenabled', '1', 60);
	} else {
		commonSetCookie('wfenabled', '0', 60);
	};
	dtwordfilter_scan();
};

function dtwordfilter_scan() {
	$$('.dtwf').each(function(d) {
		if($('wfcheckbox').checked) {
			var changeto = d.getProperty('dtwfe');
		} else {
			var changeto = d.getProperty('dtwfd');
		};
		d.innerHTML = changeto;
	});
};

function commonSetCookie(c_name,value,expiredays) {
	var exdate=new Date();
	exdate.setDate(exdate.getDate()+expiredays);
	document.cookie=c_name+ "=" +escape(value)+
	((expiredays==null) ? "" : ";expires="+exdate.toGMTString());
};

function commonGetCookie(c_name) {
	if (document.cookie.length>0) {
		c_start=document.cookie.indexOf(c_name + "=");
		if (c_start!=-1) {
    		c_start=c_start + c_name.length+1; 
			c_end=document.cookie.indexOf(";",c_start);
			if (c_end==-1) c_end=document.cookie.length;
			return unescape(document.cookie.substring(c_start,c_end));
		}; 
	};
	return "";
};

if (window.addEvent) {
	window.addEvent('load', function() {
		//yellowfades on alert boxes
		var targets = $ES('.yellowfade');
		targets.each(function(e) {
			yft(e);
		});
		load_stats_charts();
	});
}

function send_feedback(subject_prefix)
{
	var url = '/inc/ajax_feedback.php';
	var ff = $('feedbackform');
	if (ff) {
		var email  = ff.from.value;
		var from   = (ff.user.value.length>0)?ff.user.value:email;
		var params = {
			'u':       ff.user.value,
			'subject': '['+subject_prefix+'] Beta feedback from '+from,
			'from':    email,
			'body':    ff.body.value
		}
		if (!params.from||!params.body) {
			var msg = new Element('P');
			msg.setStyles('color: red; font-weight: bold;');
			msg.innerHTML = "Email and comments are required.";
			msg.injectInside(ff);
			(function() {
			 msg.remove();
			 }).delay(950);
		} else {
			params = Object.toQueryString(params);
			new Ajax(url, {
				method: 'post',
				postBody:params,
				evalResponse: true
			}).request();
		}
	}
}
